﻿using Hims.Api.Utilities;
using Hims.Domain.Services;
using Hims.Shared.EntityModels;

using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;

using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Hims.Api.Controllers
{
    /// <summary>
    /// The employee shifts controller.
    /// </summary>
    [Route("api/leave-type")]
    [Consumes("application/json")]
    [Produces("application/json")]
    public class LeaveTypesController : BaseController
    {
        /// <summary>
        /// The employee shift service
        /// </summary>
        private readonly IEmployeeShiftService employeeShiftService;

        /// <inheritdoc />
        public LeaveTypesController(IEmployeeShiftService employeeShiftService)
        {
            this.employeeShiftService = employeeShiftService;
        }

        /// <summary>
        /// To insert employee shifts
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The list of audit logs.
        /// </returns>
        [HttpPost]
        [Authorize]
        [Route("add")]
        [ProducesResponseType(500)]
        [ProducesResponseType(typeof(string), 200)]
        public async Task<ActionResult> AddAsync([FromBody] EmployeeShiftModel model)
        {
            if (model == null)
            {
                return this.ServerError();
            }

            var response = await this.employeeShiftService.AddAsync(model);
            switch (response)
            {
                case 0:
                    return this.ServerError();
                case -1:
                    return this.Conflict("Given shift details has already been exists with us.");
                default:
                    return this.Success();
            }
        }

        /// <summary>
        /// To insert employee shifts
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The list of audit logs.
        /// </returns>
        [HttpPost]
        [Authorize]
        [Route("update")]
        [ProducesResponseType(500)]
        [ProducesResponseType(typeof(string), 200)]
        public async Task<ActionResult> UpdateAsync([FromBody] EmployeeShiftModel model)
        {
            if (model == null)
            {
                return this.ServerError();
            }

            var response = await this.employeeShiftService.UpdateAsync(model);
            switch (response)
            {
                case 0:
                    return this.ServerError();
                case -1:
                    return this.Conflict("Given shift details has already been exists with us.");
                default:
                    return this.Success();
            }
        }

        /// <summary>
        /// To insert employee shifts
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The list of audit logs.
        /// </returns>
        [HttpPost]
        [Authorize]
        [Route("change-status")]
        [ProducesResponseType(500)]
        [ProducesResponseType(typeof(string), 200)]
        public async Task<ActionResult> ChangeStatusAsync([FromBody] EmployeeShiftModel model)
        {
            if (model == null)
            {
                return this.ServerError();
            }

            var response = await this.employeeShiftService.ChangeStatusAsync(model);
            switch (response)
            {
                case 0:
                    return this.ServerError();
                default:
                    return this.Success();
            }
        }

        /// <summary>
        /// To insert employee shifts
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The list of audit logs.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - List of employee shifts.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [HttpPost]
        [Authorize]
        [Route("fetch")]
        [ProducesResponseType(500)]
        [ProducesResponseType(typeof(IEnumerable<EmployeeShiftModel>),200)]
        public async Task<ActionResult> FetchAsync([FromBody] EmployeeShiftFilterModel model)
        {
            if (model == null)
            {
                return this.ServerError();
            }

            var response = await this.employeeShiftService.FetchAsync(model);
            return response != null ? this.Success(response) : this.ServerError();
        }
    }
}
